<?php
/* --------------------------------------------------------------
   skrill_giropay.php 2020-01-24
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------


   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(skrill.php,v 1.00 2003/10/27); www.oscommerce.com
   (c) 2009 XT-Commerce - community made shopping http://www.xt-commerce.com ($Id: skrill_giropay.php 39 2009-01-22 15:44:52Z mzanier $)

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contributions:
   skrill v1.0                       Autor:    Gabor Mate  <gabor(at)jamaga.hu>

   Released under the GNU General Public License
   
   // Version History
    * 2.0 xt:Commerce Adaption
    * 2.1 new workflow, tmp orders
    * 2.2 new modules
    * 2.3 updates
    * 2.4 major update, iframe integration
   
   
   ---------------------------------------------------------------------------------------*/

if (file_exists('includes/classes/class.skrill.php')) {
    require_once 'includes/classes/class.skrill.php';
} else {
    require_once '../includes/classes/class.skrill.php';
}

class skrill_giropay_ORIGIN extends fcnt_skrill
{
    
    public $images = 'skrill_giropay.png';
    
    
    // class constructor
    public function __construct()
    {
        global $order, $language;
        
        $this->_setAllowed('DE');
        $this->_setCode('giropay', 'GIR');
        
        if (is_object($order)) {
            $this->update_status();
        }
    }
    
    
    public function selection()
    {
        
        $content  = [];
        $accepted = '';
        $icons    = explode(',', $this->images);
        foreach ($icons as $key => $val) {
            $accepted .= xtc_image(DIR_WS_ICONS . 'payment/' . $val) . ' ';
        }
        
        $content = array_merge($content, [['title' => ' ', 'field' => $accepted]]);
        
        return [
            'id'          => $this->code,
            'module'      => $this->title,
            //'fields' => $content,
            'description' => $this->info
        ];
    }
}

MainFactory::load_origin_class('skrill_giropay');
